import csv
import pdb
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.colors import ListedColormap
import seaborn as sns

tips = sns.load_dataset("tips")
# first 1500 calls from the test set are used for this analysis
xhmmcalls = np.load('../outputs/data_list_xhmm_preds_test_weightedcrossent_embeddingout.npy')[1500:]
cnvnatorcalls = np.load('../outputs/data_list_cnvnator_preds_test_weightedcrossent_embeddingout.npy')[1500:]
chrs = np.load('../outputs/data_list_chrs_test_weightedcrossent_embeddingout.npy')[1500:]
inds = np.load('../outputs/data_list_indexes_test_weightedcrossent_embeddingout.npy')[1500:]
polished = np.load('../outputs/polished_rev12.npy')[1500:]
gcs = np.load('../outputs/data_list_gcs.npy')
mapp = np.load('../outputs/data_list_mapp.npy')

corrected = []
correctedgcs = []
agreedgcs = []

for i in range(len(xhmmcalls)):
    if np.argmax(xhmmcalls[i]) + 1 == np.argmax(polished[i]) == np.argmax(cnvnatorcalls[i]):
        corrected.append('XHMM call is correct\nand DECoNT agrees')  # agrees
    elif np.argmax(xhmmcalls[i]) + 1 == np.argmax(cnvnatorcalls[i]):
        corrected.append('XHMM call is correct\nDECoNT call is incorrect')  # correct
    elif np.argmax(polished[i]) == np.argmax(cnvnatorcalls[i])!= np.argmax(xhmmcalls[i]) + 1:
        corrected.append('DECoNT call is correct\nXHMM call is incorrect')  # agrees
    else:
        corrected.append('Both calls\nare incorrect')


corrected = np.asarray(corrected)

PROPS = {
    'boxprops':{'facecolor':'none', 'edgecolor':'black'},
    'medianprops':{'color':'black'},
    'whiskerprops':{'color':'black'},
    'capprops':{'color':'black'}
}

pdb.set_trace()
fig, ax = plt.subplots()
sns.stripplot(x=corrected, y=gcs, alpha=0.7)
sns.violinplot(x=corrected, y=gcs,alpha=0.2, color='white')
ax.set(ylim=(20, None))
plt.ylabel("GC Content (%)", fontweight='normal', fontsize=10)

plt.plot()


#ax.plot([0,1],[0,1], transform=ax.transAxes, color='black', linestyle='--', linewidth=0.4)

plt.show()



pdb.set_trace()
